// AppDlg.cpp : implementation file
//

#include "stdafx.h"
#include "App.h"
#include "AppDlg.h"
#include "PobieranieUchwytuOkna.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


// CAppDlg dialog




CAppDlg::CAppDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAppDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAppDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_EDIT1, edit1);
	DDX_Control(pDX, IDC_EDIT2, edit2);
}

BEGIN_MESSAGE_MAP(CAppDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BUTTON1, &CAppDlg::OnBnClickedButton1)
	ON_BN_CLICKED(IDC_BUTTON2, &CAppDlg::OnBnClickedButton2)
END_MESSAGE_MAP()


// CAppDlg message handlers

BOOL CAppDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon

	// TODO: Add extra initialization here
	CString sProcessId;	
	sProcessId.AppendFormat(L"%d",GetCurrentProcessId());
	edit1.SetWindowTextW(sProcessId);
	CString sUchwyt;
	sUchwyt.AppendFormat(L"%d",this->m_hWnd);
	edit2.SetWindowTextW(sUchwyt);	

	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAppDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this function to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAppDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CAppDlg::OnBnClickedButton1()
{
	const int MAX_COUNT=256;

	unsigned long processId = GetCurrentProcessId();
	try
	{
		CString processIdStr;
		edit1.GetWindowTextW(processIdStr);
		processId=_wtoi(processIdStr);
	}
	catch(...)
	{
		MessageBox(L"Identyfikator procesu musi by liczb");
		return;
	}

	HWND uchwytOkna=PobierzUchwytGlownegoOkna(processId);
	CString uchwytOknaStr;
	uchwytOknaStr.AppendFormat(L"%d",(int)uchwytOkna);
	edit2.SetWindowTextW(uchwytOknaStr);
	if (uchwytOkna!=0)
	{
		wchar_t nazwaOkna[MAX_COUNT];
		wchar_t nazwaKlasy[MAX_COUNT];
		::GetWindowText(uchwytOkna,nazwaOkna,MAX_COUNT);
		::GetClassName(uchwytOkna,nazwaKlasy,MAX_COUNT);
		CString opis;
		opis.AppendFormat(L"Uchwyt okna: %d \nNazwa okna: %s\nKlasa okna: %s",uchwytOkna,nazwaOkna,nazwaKlasy);
		MessageBox(opis);
		::FlashWindow(uchwytOkna,true);
	}
	else MessageBox(L"Proces o podanym numerze PID nie istnieje");

}

void CAppDlg::OnBnClickedButton2()
{
	HWND uchwytOkna= this->GetSafeHwnd();
	try
	{
		CString tekstOkna;
		edit2.GetWindowTextW(tekstOkna);
		uchwytOkna=(HWND)_wtoi(tekstOkna);
	}
	catch(...)
	{
		MessageBox(L"Uchwyt okna musi by liczb");
		return;
	}

	unsigned long processId=0;
	if (GetWindowThreadProcessId(uchwytOkna,&processId)!=0)
	{
		CString szUchwytOkna;
		szUchwytOkna.AppendFormat(L"%d",processId);
		edit1.SetWindowTextW(szUchwytOkna);
		CString wiadomosc;
		wiadomosc.AppendFormat(L"Identyfikator procesu: %d \nUchwyt Okna:  %d",processId,(int)PobierzUchwytGlownegoOkna(processId));
		MessageBox(wiadomosc);
	}
	else
		MessageBox(L"Podanemu uchwytowi nie odpowiada adne okno");

}
